VRTDRIVE U  F                      5   x 
      M l6 /    l6$L0(     l6$0$     l6$0"     l6$@!    @m h64@>     - l6p       l6D p       l6D Hp     @ l6D (p     ` l6D p     @G6 x    ` l( p0         2@ "@                                 	   	     
   
         ;------------------------------------------------------------------------------
; Vertex shader to perform billboarding of sprites
;------------------------------------------------------------------------------
vs.1.0


;------------------------------------------------------------------------------
; Vertex type expected by this shader
;    struct VERTEX
;    {
;       D3DXVECTOR3 p;        // v0.xyz  = Vertex position
;       D3DXVECTOR2 t;        // v1.xy   = Vertex tex coords
;    };
;
; Expected vertex shaders constants
;    c0-c3   = Transpose of ViewProj matrix
;    c4-c7   = Transpose of Billboard matrix
;    c8      = Sprite color
;    c9      = Sprite scale factor (square)
;    c10     = Sprite position
;
;------------------------------------------------------------------------------

; Scale the vertex
mul r1, v0, c9

; Rotate the sprites with the billboard matrix
m4x4 r0, r1, c4

; Position the sprites 
add r0.xyz, r0.xyz, c10.xyz  ; [r0] += [c0]

; Transform to projection space
m4x4 oPos, r0, c0


;------------------------------------------------------------------------------
; Vertex lighting
;------------------------------------------------------------------------------

mov oD0, c8

;------------------------------------------------------------------------------
; Texture coordinates
;-------------------

mov oT0.xy, v1.xy

   5   x 
       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64T@/      Ml T`(      m6dp    @G6 x     M l6tp     ` l( p0         2@ @ "@                                                             	         xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
max r0.x, r0.x, c[SCRATCH_CONST].x
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
max r1.x, r1.x, c[SCRATCH_CONST].x
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

mul oD0, r2, c[MATERIAL_DIFFUSE]

mov oT0, v2
mov oT1, v2
    u   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (     l6
 $     l6
 "    Ȭ l6
`(     J6$01    ̬ l6
`"    ʬ6
a    D l6(     M*%$@>     m 6DP>      l6dp!    d l6$     MT     l6"     @ l(e.     m 6>     l6!     M l p     n6L     l6$     l6"    & l6!    @G6 x       l6Pp     ` l( p0	         2@ 2@ "@ "@ 2@ 2@ 2@                                                             	         
                  vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_VEC0		4
#define LIGHT_RGB0		5
#define LIGHT_VEC1		6
#define LIGHT_RGB1		7

#define SCRATCH			8
#define MATERIAL		9

#define TEXTURE_MATRIX0_ROW0	10
#define TEXTURE_MATRIX0_ROW1	11
#define TEXTURE_MATRIX0_ROW2	12
#define TEXTURE_MATRIX0_ROW3	13

#define TEXTURE_MATRIX1_ROW0	14
#define TEXTURE_MATRIX1_ROW1	15
#define TEXTURE_MATRIX1_ROW2	16
#define TEXTURE_MATRIX1_ROW3	17

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;transform the light into texture space
dp3 r3.x, v4, -c[LIGHT_VEC0]
dp3 r3.y, v5, -c[LIGHT_VEC0]
dp3 r3.z, v6, -c[LIGHT_VEC0]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the   diffuse component
add r3, r3, c[SCRATCH].zzz
mul oD0, r3, c[SCRATCH].yyy
;mov oD0, c[SCRATCH].yyy
;store alpha to 1
mov oD0.w, c[SCRATCH].z

;transform the second light into texture space
dp3 r3.x, v4, -c[LIGHT_VEC1]
dp3 r3.y, v5, -c[LIGHT_VEC1]
dp3 r3.z, v6, -c[LIGHT_VEC1]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the   diffuse component
add r3, r3, c[SCRATCH].zzz
mul oD1, r3, c[SCRATCH].yyy
;store alpha to 1
mov oD1.w, c[SCRATCH].z

;output texture coordinates
;apply the texture matrix to the uvs
dp4 r1.x, v2, c[TEXTURE_MATRIX0_ROW0]
dp4 r1.y, v2, c[TEXTURE_MATRIX0_ROW1]
dp4 r1.z, v2, c[TEXTURE_MATRIX0_ROW2]
dp4 r1.w, v2, c[TEXTURE_MATRIX0_ROW3]
mov oT0, r1

;mov oT0, v2

dp4 r2.x, v3, c[TEXTURE_MATRIX1_ROW0]
dp4 r2.y, v3, c[TEXTURE_MATRIX1_ROW1]
dp4 r2.z, v3, c[TEXTURE_MATRIX1_ROW2]
dp4 r2.w, v3, c[TEXTURE_MATRIX1_ROW3]
mov oT1, r2

;mov oT1, v3
    a   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(      Ml $0(     L l64@/      Ml T`(     L l6dp/     ` m6D    D l6(     M l6p      M l68p     d l6$     l6"     l6!     l6$    n6LX     l6"    & l6!    @G6 x       l6Pp     ` l( p0         2@ 2@ "@ "@                                                             	         
                  xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_VEC0		4
#define LIGHT_RGB0		5
#define LIGHT_VEC1		6
#define LIGHT_RGB1		7

#define SCRATCH			8
#define MATERIAL		9

#define TEXTURE_MATRIX0_ROW0	10
#define TEXTURE_MATRIX0_ROW1	11
#define TEXTURE_MATRIX0_ROW2	12
#define TEXTURE_MATRIX0_ROW3	13

#define TEXTURE_MATRIX1_ROW0	14
#define TEXTURE_MATRIX1_ROW1	15
#define TEXTURE_MATRIX1_ROW2	16
#define TEXTURE_MATRIX1_ROW3	17

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do a simple d3d lighting with 2 lights

;do the first light
dp3 r0, v1, -c[LIGHT_VEC0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH].x
;modulate with light color
mul r0, r0.x, c[LIGHT_RGB0]

;do the second light
dp3 r1, v1, -c[LIGHT_VEC1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH].x
;modulate with light color
mul r1, r1.x, c[LIGHT_RGB1]

;add the lights togather and modulate with diffuse
add r0, r0, r1
mul oD0, r0, c[MATERIAL]
mul oB0, r0, c[MATERIAL]

;output texture coordinates
;apply the texture matrix to the uvs
dp4 r1.x, v2, c[TEXTURE_MATRIX0_ROW0]
dp4 r1.y, v2, c[TEXTURE_MATRIX0_ROW1]
dp4 r1.z, v2, c[TEXTURE_MATRIX0_ROW2]
dp4 r1.w, v2, c[TEXTURE_MATRIX0_ROW3]
mov oT0, r1

dp4 r2.x, v3, c[TEXTURE_MATRIX1_ROW0]
dp4 r2.y, v3, c[TEXTURE_MATRIX1_ROW1]
dp4 r2.z, v3, c[TEXTURE_MATRIX1_ROW2]
dp4 r2.w, v3, c[TEXTURE_MATRIX1_ROW3]
mov oT1, r2
   I   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64\@/      Ml T`(      m6dp    @ l6Pp      M l6tp     ` l6PHp      l6P(p      l6!    @G6 x     Ml Pp     ` l( p0         2@ @ "@                                                          
            	         vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

#define LIGHTCOMBINED_ROW0	10
#define LIGHTCOMBINED_ROW1	11
#define LIGHTCOMBINED_ROW2	12
#define LIGHTCOMBINED_ROW3	13

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

;add the lights togather and modulate with diffuse
;add r0, r0, r1
mul oD0, r2, c[MATERIAL_DIFFUSE]

mov oT0, v2
mov oT2, v2

;apply the texture generation matrix
dp4 oT1.x, v0, c[LIGHTCOMBINED_ROW0]
dp4 oT1.y, v0, c[LIGHTCOMBINED_ROW1]
dp4 oT1.z, v0, c[LIGHTCOMBINED_ROW2]
dp4 r2.w, v0, c[LIGHTCOMBINED_ROW3]

;clamp w to positive
;slt r1, c0, c0
;max r2.w, r2.w, r1.w
;mov oT1.w, r2.w

max oT1.w, r2.w, c[SCRATCH_CONST].x!   x        l6 p       l6 Hp     @ l6 (p     ` l6 p       l6p       l60p     @G6 x    ` l( p0         2@ @@ @                 vs.1.0

;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 r1.w, v0, c3	;save off r1.w for dot size calc
mov oPos.w, r1.w

;pass the diffuse color
mov oD0, v1

; generate dot size based on perspective distance
rcp r1.x, r1.w	;do the 1/w
mul oPts.x, r1.x, v2.x
mul oPts.x, oPts.x, oPos.z
;mov oPts.x, v2.x
xvs. 1.0

#pragma screenspace

;generate the fog texture coord
dp4 r0.x, v0, c[90]
add r0.x, r0.x, -c[91].x
mul r0.x, r0.x, c[91].y

dp4 r0.y, v0, c[92]
add r0.y, r0.y, -c[91].z
mul r0.y, r0.y, c[91].w

max r0.xy, r0.xy, c[93].xx
min r0.xy, r0.xy, c[93].zz
mov oT3.xy, r0.xy


x      @ l6 (     l6 $    *aw l6     `W l ,    Wl  ,    7lTa      =   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$T0(     L l64@/      Ml T`(      m6dp     DM l Hp      M l6tp     UdM lHHp     @G6 x    ` l( p0         2@ @ "@                                                             	         
         xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

#define TEX_MAT0_ROW0	10
#define TEX_MAT0_ROW1	11
#define TEX_MAT0_ROW2	12
#define TEX_MAT0_ROW3	13

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

mul oD0, r2, c[MATERIAL_DIFFUSE]

;dp4 oT0.x, v2, c[TEX_MAT0_ROW0]
;dp4 oT0.y, v2, c[TEX_MAT0_ROW1]
;dp4 oT0.z, v2, c[TEX_MAT0_ROW2]
;dp4 oT0.w, v2, c[TEX_MAT0_ROW3]

mul oT0.x, v2.x, c[TEX_MAT0_ROW0].x
mul oT0.y, v2.y, c[TEX_MAT0_ROW1].y

mov oT1, v2
       x ,       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6 (     l6 $    Ȭ l6 "     l60(     l60$    Ƭ l60"     l6@(     l6@$    ʬ l6@"    l6&TP(    l66\P$      l6FP"    @ l6&(    6T`1    @ l6F"    @66      l6 (    M*U$p>    m6tL>      l(7!      l6 $    M    @ l6 "     @ l(.    m 6 >      lH6$0!     l6P(    M     " l6P$     @ l(%@.    B l6P"    @G6 x      l6T`!    ` l(  p0      6     @ l(Up.      l6D(      ` 6     @ l(t.     ` n6DIp         2@ @ "@ @ @ @                               	         
                                                xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define WORLD_ROW0		4
#define WORLD_ROW1		5
#define WORLD_ROW2		6
#define WORLD_ROW3		7

#define LIGHT_VEC0		8
#define LIGHT_DIFFUSE0	9
#define LIGHT_VEC1		10
#define LIGHT_DIFFUSE1	11
#define LIGHT_VEC2		12
#define LIGHT_DIFFUSE2	13

#define SCRATCH			14
#define MATERIAL		15

#define WORLDVIEW_ROW0	16
#define WORLDVIEW_ROW1	17
#define WORLDVIEW_ROW2	18
#define WORLDVIEW_ROW3	19

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;transform the basis vector 

dp3 r0.x, v4, c[WORLD_ROW0]
dp3 r0.y, v4, c[WORLD_ROW1]
dp3 r0.z, v4, c[WORLD_ROW2]

dp3 r1.x, v3, c[WORLD_ROW0]
dp3 r1.y, v3, c[WORLD_ROW1]
dp3 r1.z, v3, c[WORLD_ROW2]

dp3 r2.x, v5, c[WORLD_ROW0]
dp3 r2.y, v5, c[WORLD_ROW1]
dp3 r2.z, v5, c[WORLD_ROW2] 

;transform the first light into texture space
dp3 r3.x, r0, -c[LIGHT_VEC0]
dp3 r3.y, r1, -c[LIGHT_VEC0]
dp3 r3.z, r2, -c[LIGHT_VEC0]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the   diffuse component
add r3, r3, c[SCRATCH].zzz
mul oD0, r3, c[SCRATCH].yyy
;store alpha to 1
mov oD0.w, c[SCRATCH].z

;transform the second light into texture space
dp3 r3.x, r0, -c[LIGHT_VEC1]
dp3 r3.y, r1, -c[LIGHT_VEC1]
dp3 r3.z, r2, -c[LIGHT_VEC1]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the specular component
add r3, r3, c[SCRATCH].zzz
mul oD1, r3, c[SCRATCH].yyy
;store alpha to 1
mov oD1.w, c[SCRATCH].z

;output texture coordinates
mov oT1, v2
mov oT2, v2

;generate the reflection texture cordinates
;transform the vertex into eye space
dp4 r0.x, v0, c[WORLDVIEW_ROW0]
dp4 r0.y, v0, c[WORLDVIEW_ROW1]
dp4 r0.z, v0, c[WORLDVIEW_ROW2]
dp4 r0.w, v0, c[WORLDVIEW_ROW3]

;generate the eye vector
dp3 r0.w, r0, r0
rsq r0.w, r0.w		
mul r0, r0, r0.w

;transform normal into eye space
dp3 r1.x, v1, c[WORLDVIEW_ROW0]
dp3 r1.y, v1, c[WORLDVIEW_ROW1]
dp3 r1.z, v1, c[WORLDVIEW_ROW2]

;normalize the eye space normal
dp3 r1.w, r1, r1
rsq r1.w, r1.w
mul r1, r1, r1.w

; Calculate E - 2*(E dot N)*N
dp3 r2.x, r0, r1
add r2.x, r2.x, r2.x
mul r1, r1, r2.x
add oT0, r0, -r1
mov oT0.w, c[SCRATCH].z
   5   x 
       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64\@/      Ml T`(      m6dp    @G6 x     M l6tp     ` l( p0         2@ @ "@                                                             	         xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

;add the lights togather and modulate with diffuse
mul oD0, r2, c[MATERIAL_DIFFUSE]

mov oT0, v2
mov oT2, v2

   I   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64\@/      Ml T`(      m6dp    @ l6Pp      M l6tp     ` l6PHp      l6P(p      l6!    @G6 x     Ml Pp     ` l( p0         2@ @ "@                                                          
            	         xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

#define LIGHTCOMBINED_ROW0	10
#define LIGHTCOMBINED_ROW1	11
#define LIGHTCOMBINED_ROW2	12
#define LIGHTCOMBINED_ROW3	13

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

mul oD0, r2, c[MATERIAL_DIFFUSE]

mov oT0, v2
mov oT2, v2

;apply the texture generation matrix
dp4 oT1.x, v0, c[LIGHTCOMBINED_ROW0]
dp4 oT1.y, v0, c[LIGHTCOMBINED_ROW1]
dp4 oT1.z, v0, c[LIGHTCOMBINED_ROW2]
dp4 r2.w, v0, c[LIGHTCOMBINED_ROW3]

max oT1.w, r2.w, c[SCRATCH_CONST].x      x #     $U l  /    l6$p0      l60(      l60$    @ l60"    5l6<01    @ l 4@/    U l6$p       l6P(      l6P$    @ l6P"       l6P!     mT`     l6$p       l6p(      l6p$    @ l6p"       l6p!     mTu     l6$p       l6(      l6$    @ l6"       l6!     n    @ l6(    ` l6$     l6"     l6!     l6 p      l6 Hp      l6 (p      l6 p     @G6 x    ` l( p0         2@ B@ D@   D         H         I         J         N             #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71
#define ZERO_CONS 72
#define SCALE_CONS 73

#define SHADOW_MATRIX_ROW0 74
#define SHADOW_MATRIX_ROW1 75
#define SHADOW_MATRIX_ROW2 76
#define SHADOW_MATRIX_ROW3 77

#define SHADOW_COLOR 78

xvs.1.1

;transform it by first matrix
mul r8, v2, c[SCALE_CONS].x
mov a0.x, r8.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w
mul r0, r0, v1.x

;transform by second matrix
mov a0.x, r8.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.y, r0

;transform by third matrix
mov a0.x, r8.z
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.z, r0

;transform by fourth matrix
mov a0.x, r8.w
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.w, r0

;transform by the shadow matrix
dp4 r1.x, r0, c[SHADOW_MATRIX_ROW0]
dp4 r1.y, r0, c[SHADOW_MATRIX_ROW1]
dp4 r1.z, r0, c[SHADOW_MATRIX_ROW2]
dp4 r1.w, r0, c[SHADOW_MATRIX_ROW3]

;transform by view projection matrix
dp4 oPos.x, r1, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r1, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r1, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r1, c[VIEW_PROJ_ROW3]

mov oD0, c[SHADOW_COLOR];
mov oB0, c[SHADOW_COLOR];

   5   x 
       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64T@/      Ml T`(      m6dp    @G6 x     M l6tp     ` l( p0         2@ @ "@                                                             	         xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

;add the lights togather and modulate with diffuse
mul oD0, r2, c[MATERIAL_DIFFUSE]

mov oT0, v2
mov oT1, v2

    !   x        l6 p       l6 Hp     @ l6 (p     ` l6 p       l6p       l6Hp     @G6 x    ` l( p0         2@ @@ "@                 vs.1.0


;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 oPos.w, v0, c3

;modulate the intensity with material color
mov oD0, v1
mov oT0, v2
   U   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6 (     l6 $     l6 "     l6P(     J6$L01    ¬ l6P"    6Q    @G6 x    @l(%T@.      l6T`!    ` l(  p0      6     @ l(Up.      l6D(      ` 6     @ l(t.     ` n6DIp         2@ @ "@                                   xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define WORLDVIEW_ROW0	4
#define WORLDVIEW_ROW1	5
#define WORLDVIEW_ROW2	6
#define WORLDVIEW_ROW3	7

#define SCRATCH 8

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;transform the vertex into eye space
dp4 r0.x, v0, c[WORLDVIEW_ROW0]
dp4 r0.y, v0, c[WORLDVIEW_ROW1]
dp4 r0.z, v0, c[WORLDVIEW_ROW2]
dp4 r0.w, v0, c[WORLDVIEW_ROW3]

;generate the eye vector
dp3 r0.w, r0, r0
rsq r0.w, r0.w		
mul r0, r0, r0.w

;transform normal into eye space
dp3 r1.x, v1, c[WORLDVIEW_ROW0]
dp3 r1.y, v1, c[WORLDVIEW_ROW1]
dp3 r1.z, v1, c[WORLDVIEW_ROW2]

;normalize the eye space normal
dp3 r1.w, r1, r1
rsq r1.w, r1.w
mul r1, r1, r1.w

; Calculate E - 2*(E dot N)*N
dp3 r2.x, r0, r1
add r2.x, r2.x, r2.x
mul r1, r1, r2.x
add oT0, r0, -r1
mov oT0.w, c[SCRATCH].z

;move the second texture
mov oT1, v2
    5   x 
      l6 (     l6 $     l6 "     l6 !    ` h6 .      l6p       l6 p       l6 Hp     @ l6 (p     ` l6 p       l6Hp     @G6 x    ` l( p0         2@ 2@ @@ 2@                         ;------------------------------------------------------------------------------
; Vertex shader to perform billboarding of sprites with a minimal number of
; register pushes and texture setting.
;------------------------------------------------------------------------------
vs.1.0


;------------------------------------------------------------------------------
; Vertex type expected by this shader
;    struct VERTEX
;    {
;       D3DXVECTOR3 p;				// v0.xyz  = Vertex position
;       D3DXVECTOR3 t;				// v1.xyz  = Vertex tex coords
;		D3DCOLOR diffuse;			// v2.xyz  = Vertex color
;		D3DXVECTOR3 displacement;	// v3.xyz  = Vertex translation into world space
;    };
;
; Expected vertex shaders constants
;    c0-c3   = Transpose of ViewProj matrix
;    c4-c7   = Transpose of Billboard matrix
;
;------------------------------------------------------------------------------

; Rotate the sprites with the billboard matrix
m4x4 r0, v0, c4

; Position the sprites 
add r0.xyz, r0.xyz, v3.xyz  ; [r0] += [v3]

; Transform to projection space
m4x4 oPos, r0, c0


;------------------------------------------------------------------------------
; Vertex lighting
;------------------------------------------------------------------------------

mov oD0, v2

;------------------------------------------------------------------------------
; Texture coordinates
;-------------------

mov oT0, v1

       x        l6 p       l6 Hp     @ l6 (p     ` l6 p       l6p     @G6 x    ` l( p0         2@ @@                 vs.1.1

;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 oPos.w, v0, c3

mov oD0, v1


   U   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (     l6
 $     l6
 "    F l6
`(     J6$01    H l6
`"    D6
a      l6Hp      M*%$@>     m 6DP>    l6dTp!    @G6 x     MT    ` l(  p0     @ l(e.     m 6>     M l!p          2@ "@ @ @ @                               
         	             vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define WORLD_ROW0		4
#define WORLD_ROW1		5
#define WORLD_ROW2		6
#define WORLD_ROW3		7

#define LIGHT_VEC		8
#define SCRATCH			9
#define LIGHT_VEC2		10

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;transform the basis vector 

;dp3 r0.x, v3, c[WORLD_ROW0]
;dp3 r0.y, v3, c[WORLD_ROW1]
;dp3 r0.z, v3, c[WORLD_ROW2]

;dp3 r1.x, v2, c[WORLD_ROW0]
;dp3 r1.y, v2, c[WORLD_ROW1]
;dp3 r1.z, v2, c[WORLD_ROW2]

;dp3 r2.x, v4, c[WORLD_ROW0]
;dp3 r2.y, v4, c[WORLD_ROW1]
;dp3 r2.z, v4, c[WORLD_ROW2] 

;transform the light into texture space
dp3 r3.x, v3, -c[LIGHT_VEC]
dp3 r3.y, v2, -c[LIGHT_VEC]
dp3 r3.z, v4, -c[LIGHT_VEC]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the   diffuse component
add r3, r3, c[SCRATCH].zzz
mul oD0, r3, c[SCRATCH].yyy
;store alpha to 1
mov oD0.w, c[SCRATCH].z

;transform the second light into texture space
dp3 r3.x, v3, -c[LIGHT_VEC2]
dp3 r3.y, v2, -c[LIGHT_VEC2]
dp3 r3.z, v4, -c[LIGHT_VEC2]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the   diffuse component
add r3, r3, c[SCRATCH].zzz
mul oD1, r3, c[SCRATCH].yyy
;store alpha to 1
mov oD1.w, c[SCRATCH].z

;output texture coordinates
mov oT0, v1
mov oT1, v1   5   x 
       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64T@/      Ml T`(      m6dp    @G6 x     M l6tp     ` l( p0         2@ @ "@                                                             	         xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mad r2, r1.x, c[LIGHT_DIFFUSE1], r0

;add the lights togather and modulate with diffuse
mul oD0, r2, c[MATERIAL_DIFFUSE]

mov oT0, v2
mov oT1, v2
   U   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6 (     l6 $     l6 "     l6P(     J6$L01    ¬ l6P"    6Q    @G6 x    @l(%T@.      l6T`!    ` l(  p0      6     @ l(Up.      l6D(      ` 6     @ l(t.     ` n6DIp         2@ @ "@                                   xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define WORLDVIEW_ROW0	4
#define WORLDVIEW_ROW1	5
#define WORLDVIEW_ROW2	6
#define WORLDVIEW_ROW3	7

#define SCRATCH 8

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;transform the vertex into eye space
dp4 r0.x, v0, c[WORLDVIEW_ROW0]
dp4 r0.y, v0, c[WORLDVIEW_ROW1]
dp4 r0.z, v0, c[WORLDVIEW_ROW2]
dp4 r0.w, v0, c[WORLDVIEW_ROW3]

;generate the eye vector
dp3 r0.w, r0, r0
rsq r0.w, r0.w		
mul r0, r0, r0.w

;transform normal into eye space
dp3 r1.x, v1, c[WORLDVIEW_ROW0]
dp3 r1.y, v1, c[WORLDVIEW_ROW1]
dp3 r1.z, v1, c[WORLDVIEW_ROW2]

;normalize the eye space normal
dp3 r1.w, r1, r1
rsq r1.w, r1.w
mul r1, r1, r1.w

; Calculate E - 2*(E dot N)*N
dp3 r2.x, r0, r1
add r2.x, r2.x, r2.x
mul r1, r1, r2.x
add oT0, r0, -r1
mov oT0.w, c[SCRATCH].z

;move the second texture
mov oT1, v2
   !   x        l6 p       l6 Hp     @ l6 (p     ` l6 p       l6p       l6Hp     @G6 x    ` l( p0         2@ @@ "@                 vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 oPos.w, v0, c3

mov oD0, v1
mov oT0, v2
    %   x 	       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
p       l6Hp       l6Pp     @G6 x    ` l( p0         2@ 2@ "@                                                             	         xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 oD0, v1, -c[LIGHT_DIR0]

mov oT0, v2
mov oT1, v2
    !   x        l6 p       l6 Hp     @ l6 (p     ` l6  !     6     @ l 0p     @G6 x    ` l( p0         2@ @@ @                 vs.1.0

;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 r1.w, v0, c3	;save off r1.w for dot size calc
mov oPos.w, r1.w

;pass the diffuse color
mov oD0, v1

; generate dot size based on perspective distance
rcp r1.x, r1.w	;do the 1/w
mul oPts.x, r1.x, v2.x
;mov oPts.x, v2.x
    !   x        l6 p       l6 Hp     @ l6 (p     ` l6 p       l6p        l60p     @G6 x    ` l( p0         2@ @@ @                 vs.1.0

;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 oPos.w, v0, c3

;pass the diffuse color
mov oD0, v1

;pass the point size
mov oPts.x, v2.x
    ]   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6 (     l6 $    Ȭ l6 "     l60(     l60$    Ƭ l60"     l6@(     l6@$    ʬ l6@"    l6&LP(    l66TP$      l6FP"    @G6 x     6T`1    ` l(  p0      6     @ l(Up.     m 6t>     M lp          2@ @ "@ @ @ @                               	             vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define WORLD_ROW0		4
#define WORLD_ROW1		5
#define WORLD_ROW2		6
#define WORLD_ROW3		7

#define LIGHT_VEC		8
#define SCRATCH			9
#define AMBIENT			10

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;transform the basis vector 

dp3 r0.x, v4, c[WORLD_ROW0]
dp3 r0.y, v4, c[WORLD_ROW1]
dp3 r0.z, v4, c[WORLD_ROW2]

dp3 r1.x, v3, c[WORLD_ROW0]
dp3 r1.y, v3, c[WORLD_ROW1]
dp3 r1.z, v3, c[WORLD_ROW2]

dp3 r2.x, v5, c[WORLD_ROW0]
dp3 r2.y, v5, c[WORLD_ROW1]
dp3 r2.z, v5, c[WORLD_ROW2] 

;transform the light into texture space
dp3 r3.x, r0, -c[LIGHT_VEC]
dp3 r3.y, r1, -c[LIGHT_VEC]
dp3 r3.z, r2, -c[LIGHT_VEC]

;normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w

;scale the vector to 0 to 1 and store it in the   diffuse component
add r3, r3, c[SCRATCH].zzz
mul oD0, r3, c[SCRATCH].yyy
;store alpha to 1
mov oD0.w, c[SCRATCH].z

;output texture coordinates
mov oT0, v2
mov oT1, v2       x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6p     @G6 x    ` l( p0         2@ 2@                 xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

;transform the vertex into clip space
dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

sge oD0, v0, v0   !   x        l6 p       l6 Hp     @ l6 (p     ` l6 p     , l6p     , l68p     @G6 x    ` l( p0         2@ 2@                          xvs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define SHADOW_COLOR 4

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

mov oD0, c[SHADOW_COLOR]
mov oB0, c[SHADOW_COLOR]      x .     U l  /    l6$Lp       l60(      l60$    @ l60"       l60!     l6@(    & l6@$    F l6@"    Ul6$\p       l6FP(    @ l6F(     Ul T`(      U l6dp/     Ul (     ` m6      l6(    U l6p       l6$    @ l6"       l6!     l6$p       l6 (      l6 $    @ l6 "       l6 !     l6$p       l6 (      l6 $    @ l6 "       l6 !    @ l 4@/     mP     mT`_     m%p     l6t p      l6t Hp      l6t (p      l6t p      l6tPp       l6tPHp       l6tP(p     @ l6t!    @G6 x    Ul Pp     ` l( p0         2@ B@ D@ @ "@   D         H         I         J         K         L         M         O           N         #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71

#define LIGHT_DIR0		72
#define LIGHT_DIFFUSE0	73
#define LIGHT_DIR1		74
#define LIGHT_DIFFUSE1	75

#define SCRATCH_CONST	76
#define SCALE_CONS		77

#define MATERIAL_DIFFUSE 78

#define LIGHTCOMBINED_ROW0	79
#define LIGHTCOMBINED_ROW1	80
#define LIGHTCOMBINED_ROW2	81
#define LIGHTCOMBINED_ROW3	82

xvs.1.1

;transform it by first matrix
mul r6, v2, c[SCALE_CONS].x
mov a0.x, r6.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w

;transform the normal into world space
dp3 r7.x, v3, c[SKINNING_MATRIX_ROW0]
dp3 r7.y, v3, c[SKINNING_MATRIX_ROW1]
dp3 r7.z, v3, c[SKINNING_MATRIX_ROW2]

;do the first light
dp3 r8, r7, -c[LIGHT_DIR0]
;make sure it is non negative
max r8.x, r8.x, c[SCRATCH_CONST].x
;modulate with light color
mul r8, r8.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r9, r7, -c[LIGHT_DIR1]
;make sure it is non negative
max r9.x, r9.x, c[SCRATCH_CONST].x
;modulate with light color
mad r10, r9.x, c[LIGHT_DIFFUSE1], r8

;add the lights togather and modulate with diffuse
mul oD0, r10, c[MATERIAL_DIFFUSE]

;transform by second matrix
mov a0.x, r6.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w

;transform by third matrix
mov a0.x, r6.z
dp4 r2.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r2.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r2.z, v0, c[SKINNING_MATRIX_ROW2]
mov r2.w, v0.w

;transform by fourth matrix
mov a0.x, r6.w
dp4 r3.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r3.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r3.z, v0, c[SKINNING_MATRIX_ROW2]
mov r3.w, v0.w

mul r0, r0, v1.x
mad r0, r1, v1.y, r0
mad r0, r2, v1.z, r0
mad r0, r3, v1.w, r0

;transform by view projection matrix
dp4 oPos.x, r0, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r0, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r0, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r0, c[VIEW_PROJ_ROW3]

;apply the texture generation matrix
dp4 oT1.x, r0, c[LIGHTCOMBINED_ROW0]
dp4 oT1.y, r0, c[LIGHTCOMBINED_ROW1]
dp4 oT1.z, r0, c[LIGHTCOMBINED_ROW2]
dp4 r2.w, r0, c[LIGHTCOMBINED_ROW3]

;clamp w to positive
max oT1.w, r2.w, c[SCRATCH_CONST].x

mov oT0, v4
mov oT2, v4
   u   x      U l  ,    l6$Lp       l60(      l60$    @ l60"       l60!     l6@(    & l6@$    F l6@"    Ul6$Tp       l6FP(    @ l6F(     Ul T`(      U l6dp/     Ul (     ` m6      l6(    U l6p       l6$    @ l6"       l6!    @ l 4 /     l      l6$ p      l6$ Hp      l6$ (p      l6$ p     @G6 x    ` l( p0         2@ B@ D@ @ "@   D         H         I         J         K         L         M            N         #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71

#define LIGHT_DIR0		72
#define LIGHT_DIFFUSE0	73
#define LIGHT_DIR1		74
#define LIGHT_DIFFUSE1	75

#define SCRATCH_CONST	76
#define SCALE_CONS		77

#define MATERIAL_DIFFUSE 78

xvs.1.1

;transform it by first matrix
mul r6, v2, c[SCALE_CONS].x
mov a0.x, r6.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w

;transform the normal into world space
dp3 r7.x, v3, c[SKINNING_MATRIX_ROW0]
dp3 r7.y, v3, c[SKINNING_MATRIX_ROW1]
dp3 r7.z, v3, c[SKINNING_MATRIX_ROW2]

;do the first light
dp3 r8, r7, -c[LIGHT_DIR0]
;make sure it is non negative
max r8.x, r8.x, c[SCRATCH_CONST].x
;modulate with light color
mul r8, r8.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r9, r7, -c[LIGHT_DIR1]
;make sure it is non negative
max r9.x, r9.x, c[SCRATCH_CONST].x
;modulate with light color
mad r10, r9.x, c[LIGHT_DIFFUSE1], r8

;add the lights togather and modulate with diffuse
mul oD0, r10, c[MATERIAL_DIFFUSE]

;transform by second matrix
mov a0.x, r6.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w

mul r0, r0, v1.x
mad r0, r1, v1.y, r0

;transform by view projection matrix
dp4 oPos.x, r0, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r0, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r0, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r0, c[VIEW_PROJ_ROW3]

mov oT0, v4
mov oT1, v4
      x )     U l  /    l6$Lp       l60(      l60$    @ l60"       l60!     l6@(    & l6@$    F l6@"    Ul6$\p       l6FP(    @ l6F(     Ul T`(      U l6dp/     Ul (     ` m6      l6(    U l6p       l6$    @ l6"       l6!     l6$p       l6 (      l6 $    @ l6 "       l6 !     l6$p       l6 (      l6 $    @ l6 "       l6 !    @ l 4@/     mP     mT`_     m%p     l6t p      l6t Hp      l6t (p      l6t p     @G6 x    ` l( p0         2@ B@ D@ @ "@   D         H         I         J         K         L         M            N         #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71

#define LIGHT_DIR0		72
#define LIGHT_DIFFUSE0	73
#define LIGHT_DIR1		74
#define LIGHT_DIFFUSE1	75

#define SCRATCH_CONST	76
#define SCALE_CONS		77

#define MATERIAL_DIFFUSE 78

#define LIGHTCOMBINED_ROW0	79
#define LIGHTCOMBINED_ROW1	80
#define LIGHTCOMBINED_ROW2	81
#define LIGHTCOMBINED_ROW3	82

xvs.1.1

;transform it by first matrix
mul r6, v2, c[SCALE_CONS].x
mov a0.x, r6.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w

;transform the normal into world space
dp3 r7.x, v3, c[SKINNING_MATRIX_ROW0]
dp3 r7.y, v3, c[SKINNING_MATRIX_ROW1]
dp3 r7.z, v3, c[SKINNING_MATRIX_ROW2]

;do the first light
dp3 r8, r7, -c[LIGHT_DIR0]
;make sure it is non negative
max r8.x, r8.x, c[SCRATCH_CONST].x
;modulate with light color
mul r8, r8.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r9, r7, -c[LIGHT_DIR1]
;make sure it is non negative
max r9.x, r9.x, c[SCRATCH_CONST].x
;modulate with light color
mad r10, r9.x, c[LIGHT_DIFFUSE1], r8

;add the lights togather and modulate with diffuse
mul oD0, r10, c[MATERIAL_DIFFUSE]

;transform by second matrix
mov a0.x, r6.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w

;transform by third matrix
mov a0.x, r6.z
dp4 r2.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r2.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r2.z, v0, c[SKINNING_MATRIX_ROW2]
mov r2.w, v0.w

;transform by fourth matrix
mov a0.x, r6.w
dp4 r3.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r3.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r3.z, v0, c[SKINNING_MATRIX_ROW2]
mov r3.w, v0.w

mul r0, r0, v1.x
mad r0, r1, v1.y, r0
mad r0, r2, v1.z, r0
mad r0, r3, v1.w, r0

;transform by view projection matrix
dp4 oPos.x, r0, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r0, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r0, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r0, c[VIEW_PROJ_ROW3]

mov oT0, v4
mov oT2, v4
    ]  x W     dU l  /    @6$p0      l60(      l60$    @ l60"       l60!    @ l 4@/     l6P(    , l6P$    L l6P"    
 l6`(    * l6`$    J l6`"     l6p(    . l6p$    N l6p"    @ l T.    @ l d.    @ l t.    Ul6$Lp       l6(      l6$    @ l6"       l6!     m      l60(    , l60$    L l60"    
 l6@(    * l6@$    J l6@"     l6P(    . l6P$    N l6P"     n4`     nDp^     nT    l6$Tp       l6(      l6$    @ l6"       l6!     lT     l6(    , l6$    L l6"    
 l6 (    * l6 $    J l6 "     l60(    . l60$    N l60"     mT@     mTP     nT5`     l6$p       l6p(      l6p$    @ l6p"       l6p!     nu     l6p(    , l6p$    L l6p"    
 l6(    * l6$    J l6"     l6(    . l6$    N l6"     mu     m ^     m      l6 p      l6 Hp      l6 (p      l6 p       l60(      l60$      l6&0"    @G6 x      lh640!    ` l(  p0      6     @ l(5@.    @u 6DP>    @U lTp 
         2@ B@ D@ @ "@ @ @ @   D         H         L         J         K         L           I         #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71
#define LIGHT_DIRECTION 72
#define MATERIAL_DIFFUSE 73
#define ZERO_CONS 74
#define SCALE_CONS 75

xvs.1.1

;transform it by first matrix
mul r8, v2, c[SCALE_CONS].x
mov a0.x, r8.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w
mul r0, r0, v1.x

;transform the basis vector by this matrix 
dp3 r2.x, v6, c[SKINNING_MATRIX_ROW0]
dp3 r2.y, v6, c[SKINNING_MATRIX_ROW1]
dp3 r2.z, v6, c[SKINNING_MATRIX_ROW2]

dp3 r3.x, v5, c[SKINNING_MATRIX_ROW0]
dp3 r3.y, v5, c[SKINNING_MATRIX_ROW1]
dp3 r3.z, v5, c[SKINNING_MATRIX_ROW2]

dp3 r4.x, v7, c[SKINNING_MATRIX_ROW0]
dp3 r4.y, v7, c[SKINNING_MATRIX_ROW1]
dp3 r4.z, v7, c[SKINNING_MATRIX_ROW2] 

mul r5, r2.xyz, v1.x
mul r6, r3.xyz, v1.x
mul r7, r4.xyz, v1.x

;transform by second matrix
mov a0.x, r8.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.y, r0

dp3 r2.x, v6, c[SKINNING_MATRIX_ROW0]
dp3 r2.y, v6, c[SKINNING_MATRIX_ROW1]
dp3 r2.z, v6, c[SKINNING_MATRIX_ROW2]

dp3 r3.x, v5, c[SKINNING_MATRIX_ROW0]
dp3 r3.y, v5, c[SKINNING_MATRIX_ROW1]
dp3 r3.z, v5, c[SKINNING_MATRIX_ROW2]

dp3 r4.x, v7, c[SKINNING_MATRIX_ROW0]
dp3 r4.y, v7, c[SKINNING_MATRIX_ROW1]
dp3 r4.z, v7, c[SKINNING_MATRIX_ROW2] 

mad r5, r2.xyz, v1.y, r5
mad r6, r3.xyz, v1.y, r6
mad r7, r4.xyz, v1.y, r7

;transform by third matrix
mov a0.x, r8.z
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.z, r0

dp3 r2.x, v6, c[SKINNING_MATRIX_ROW0]
dp3 r2.y, v6, c[SKINNING_MATRIX_ROW1]
dp3 r2.z, v6, c[SKINNING_MATRIX_ROW2]

dp3 r3.x, v5, c[SKINNING_MATRIX_ROW0]
dp3 r3.y, v5, c[SKINNING_MATRIX_ROW1]
dp3 r3.z, v5, c[SKINNING_MATRIX_ROW2]

dp3 r4.x, v7, c[SKINNING_MATRIX_ROW0]
dp3 r4.y, v7, c[SKINNING_MATRIX_ROW1]
dp3 r4.z, v7, c[SKINNING_MATRIX_ROW2] 

mad r5, r2.xyz, v1.z, r5
mad r6, r3.xyz, v1.z, r6
mad r7, r4.xyz, v1.z, r7

;transform by fourth matrix
mov a0.x, r8.w
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.w, r0

dp3 r2.x, v6, c[SKINNING_MATRIX_ROW0]
dp3 r2.y, v6, c[SKINNING_MATRIX_ROW1]
dp3 r2.z, v6, c[SKINNING_MATRIX_ROW2]

dp3 r3.x, v5, c[SKINNING_MATRIX_ROW0]
dp3 r3.y, v5, c[SKINNING_MATRIX_ROW1]
dp3 r3.z, v5, c[SKINNING_MATRIX_ROW2]

dp3 r4.x, v7, c[SKINNING_MATRIX_ROW0]
dp3 r4.y, v7, c[SKINNING_MATRIX_ROW1]
dp3 r4.z, v7, c[SKINNING_MATRIX_ROW2] 

mad r5, r2.xyz, v1.w, r5
mad r6, r3.xyz, v1.w, r6
mad r7, r4.xyz, v1.w, r7

;transform by view projection matrix
dp4 oPos.x, r0, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r0, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r0, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r0, c[VIEW_PROJ_ROW3]

dp3 r0, v3, -c[LIGHT_DIRECTION]
;make sure it is non negative
max r0.x, r0.x, c[ZERO_CONS].x
;modulate the intensity with material color
mul oD0, r0.x, c[MATERIAL_DIFFUSE]

;transform the light into texture space
dp3 r10.x, r5, -c[LIGHT_DIRECTION]
dp3 r10.y, r6, -c[LIGHT_DIRECTION]
dp3 r10.z, r7, -c[LIGHT_DIRECTION]

;normalize the light vector
dp3 r10.w, r10, r10
rsq r10.w, r10.w
mul r10, r10, r10.w

;scale the vector to 0 to 1 and store it in the specular component
add r10, r10, c[ZERO_CONS].zzz
mul oD0, r10, c[ZERO_CONS].yyy

;store alpha to 1
mov oD0.w, c[ZERO_CONS].z

mov oT0, v4
mov oT1, v4
      x <     dU l  /    @6$p0      l60(      l60$    @ l60"    @56$01    @ l 4@/    
 l6P(    * l6P$    J l6P"     l6`(    , l6`$    L l6`"     l6p(    . l6p$    N l6p"    l6VL(    l6f\$      l6v"     l6V (      l7!     l6v "    6fT    U l6$p      @ l(.    @u 6>      l60!       l6P!    @U       l6p!     @ l(0.    @u 64P>       l6!    @U lT P       l6P(      l6P$    @ l6P"     l6$p      mT`      l6p(      l6p$    @ l6p"     l6$p      mTu      l6(      l6$    @ l6"     ll6 !     n     l6 p      l6 Hp      l6 (p      l6 p      l6Pp      l6PHp      l6P(p      l6!    @G6 x     @lP      ` l( p0
         2@ B@ D@ @ "@ @ @ 2@   D         H         P         J         K         L            #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71
#define LIGHT_DIRECTION 72
#define LIGHT_DIRECTION2 76
#define MATERIAL_DIFFUSE 73
#define ZERO_CONS 74
#define SCALE_CONS 75

#define LIGHTCOMBINED_ROW0	76
#define LIGHTCOMBINED_ROW1	77
#define LIGHTCOMBINED_ROW2	78
#define LIGHTCOMBINED_ROW3	79

xvs.1.1

;transform it by first matrix
mul r8, v2, c[SCALE_CONS].x
mov a0.x, r8.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w
mul r0, r0, v1.x

;do lighting
;transpose the local to world matrix to get world to local
;
;mov r9.x, c[SKINNING_MATRIX_ROW0].x
;mov r9.y, c[SKINNING_MATRIX_ROW1].x
;mov r9.z, c[SKINNING_MATRIX_ROW2].x

;mov r10.x, c[SKINNING_MATRIX_ROW0].y
;mov r10.y, c[SKINNING_MATRIX_ROW1].y
;mov r10.z, c[SKINNING_MATRIX_ROW2].y

;mov r11.x, c[SKINNING_MATRIX_ROW0].z
;mov r11.y, c[SKINNING_MATRIX_ROW1].z
;mov r11.z, c[SKINNING_MATRIX_ROW2].z

;dp3 r2.x, v5, r9
;dp3 r2.y, v5, r10
;dp3 r2.z, v5, r11

;dp3 r3.x, v7, r9
;dp3 r3.y, v7, r10
;dp3 r3.z, v7, r11

;dp3 r4.x, v6, r9
;dp3 r4.y, v6, r10
;dp3 r4.z, v6, r11

;mov r2, v5
;mov r3, v7
;mov r4, v6

dp3 r2.x, v5, c[SKINNING_MATRIX_ROW0]
dp3 r2.y, v5, c[SKINNING_MATRIX_ROW1]
dp3 r2.z, v5, c[SKINNING_MATRIX_ROW2]

dp3 r3.x, v6, c[SKINNING_MATRIX_ROW0]
dp3 r3.y, v6, c[SKINNING_MATRIX_ROW1]
dp3 r3.z, v6, c[SKINNING_MATRIX_ROW2]

dp3 r4.x, v7, c[SKINNING_MATRIX_ROW0]
dp3 r4.y, v7, c[SKINNING_MATRIX_ROW1]
dp3 r4.z, v7, c[SKINNING_MATRIX_ROW2]

;transform the light into texture space
dp3 r5.x, r2, -c[LIGHT_DIRECTION]
dp3 r5.y, r3, -c[LIGHT_DIRECTION]
dp3 r5.z, r4, -c[LIGHT_DIRECTION]

;normalize the light vector
dp3 r5.w, r5, r5
rsq r5.w, r5.w
mul r5, r5, r5.w

;scale the vector to 0 to 1 and store it in the specular component
add r5, r5, c[ZERO_CONS].zzz
mul r5, r5, c[ZERO_CONS].yyy

;dp3 r6.x, v3, c[SKINNING_MATRIX_ROW0]
;dp3 r6.y, v3, c[SKINNING_MATRIX_ROW1]
;dp3 r6.z, v3, c[SKINNING_MATRIX_ROW2]

;do self shadowing
;dp3 r1, r6, -c[LIGHT_DIRECTION]
;sge r2, r1.x, c[ZERO_CONS].x

;dp3 oD0, -c[LIGHT_DIRECTION], v3
;mov oD0, -c[LIGHT_DIRECTION]

mov oD0, r5
mov oD0.w, c[ZERO_CONS].z

;transform the second light into texture space
dp3 r5.x, r2, -c[LIGHT_DIRECTION2]
dp3 r5.y, r3, -c[LIGHT_DIRECTION2]
dp3 r5.z, r4, -c[LIGHT_DIRECTION2]

;normalize the light vector
dp3 r5.w, r5, r5
rsq r5.w, r5.w
mul r5, r5, r5.w

;scale the vector to 0 to 1 and store it in the specular component
add r5, r5, c[ZERO_CONS].zzz
mul r5, r5, c[ZERO_CONS].yyy

;do self shadowing
;dp3 r1, r6, -c[LIGHT_DIRECTION2]
;sge r2, r1.x, c[ZERO_CONS].x
;mul oD1, r1, r2

mov oD1, r5
mov oD1.w, c[ZERO_CONS].z

;transform by second matrix
mov a0.x, r8.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.y, r0

;dp3 r5.x, v6, c[SKINNING_MATRIX_ROW0]
;dp3 r5.y, v6, c[SKINNING_MATRIX_ROW1]
;dp3 r5.z, v6, c[SKINNING_MATRIX_ROW2]
;mad r2.xyz, r5.xyz, v1.y, r2.xyz

;dp3 r5.x, v5, c[SKINNING_MATRIX_ROW0]
;dp3 r5.y, v5, c[SKINNING_MATRIX_ROW1]
;dp3 r5.z, v5, c[SKINNING_MATRIX_ROW2]
;mad r3.xyz, r5.xyz, v1.y, r3.xyz

;dp3 r5.x, v4, c[SKINNING_MATRIX_ROW0]
;dp3 r5.y, v4, c[SKINNING_MATRIX_ROW1]
;dp3 r5.z, v4, c[SKINNING_MATRIX_ROW2]
;mad r4.xyz, r5.xyz, v1.y, r4.xyz

;transform by third matrix
mov a0.x, r8.z
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.z, r0

;transform by fourth matrix
mov a0.x, r8.w
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.w, r0

;transform by view projection matrix
dp4 oPos.x, r0, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r0, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r0, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r0, c[VIEW_PROJ_ROW3]

mov oT0, v4

;apply the texture generation matrix
dp4 oT1.x, r0, c[LIGHTCOMBINED_ROW0]
dp4 oT1.y, r0, c[LIGHTCOMBINED_ROW1]
dp4 oT1.z, r0, c[LIGHTCOMBINED_ROW2]
dp4 r2.w, r0, c[LIGHTCOMBINED_ROW3]

;clamp w to positive
slt r1, c0, c0
max r2.w, r2.w, r1.w
mov oT1.w, r2.w

mov oT2, v4
       x       dU l  /      l6$p       l60(      l60$    @ l60"       l60!    @ l 4@/    U l6$p       l6P(      l6P$    @ l6P"       l6P!     mT`     l6$p       l6p(      l6p$    @ l6p"       l6p!     mTu     l6$p       l6(      l6$    @ l6"       l6!     n     l6p      l6 p      l6 Hp      l6 (p      l6 p     @G6 x    ` l( p0         2@ B@ D@   D         K             #define SKINNING_MATRIX_ROW0 a0.x-96
#define SKINNING_MATRIX_ROW1 a0.x-95
#define SKINNING_MATRIX_ROW2 a0.x-94
#define SKINNING_MATRIX_ROW3 a0.x-93
#define VIEW_PROJ_ROW0	68
#define VIEW_PROJ_ROW1	69
#define VIEW_PROJ_ROW2	70
#define VIEW_PROJ_ROW3	71
#define SCALE_CONS 75

xvs.1.1

;transform it by first matrix
mul r8, v2, c[SCALE_CONS].x
mov a0.x, r8.x
dp4 r0.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r0.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r0.z, v0, c[SKINNING_MATRIX_ROW2]
mov r0.w, v0.w
mul r0, r0, v1.x

;transform by second matrix
mov a0.x, r8.y
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.y, r0

;transform by third matrix
mov a0.x, r8.z
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.z, r0

;transform by fourth matrix
mov a0.x, r8.w
dp4 r1.x, v0, c[SKINNING_MATRIX_ROW0]
dp4 r1.y, v0, c[SKINNING_MATRIX_ROW1]
dp4 r1.z, v0, c[SKINNING_MATRIX_ROW2]
mov r1.w, v0.w
mad r0, r1, v1.w, r0

;transform by view projection matrix
dp4 oPos.x, r0, c[VIEW_PROJ_ROW0]
dp4 oPos.y, r0, c[VIEW_PROJ_ROW1]
dp4 oPos.z, r0, c[VIEW_PROJ_ROW2]
dp4 oPos.w, r0, c[VIEW_PROJ_ROW3]

sge oD0, v0, v0    =   x        l6 p       l6 Hp     @ l6 (p     ` l6  !    ,l60.    l l64@>     6DX    @60P    @G6 x     @ l(E`.     l6dp(    ` l(  p0      @ l t(      @ l(     Ll p          2@ 2@ @@ @                         
                  ;------------------------------------------------------------------------------
; Vertex shader to perform billboarding of sprites
;------------------------------------------------------------------------------
vs.1.0


;------------------------------------------------------------------------------
; Vertex type expected by this shader
;    struct VERTEX
;    {
;       D3DXVECTOR3 p;        // v0.xyz  = Vertex position
;       D3DXVECTOR2 n;        // v1.xyz  = Vertex tex coords
;		D3DCOLOR	diffuse;  // v2.xyzw = RGBA
;		float		size;	  // v3.x	 = Point sprite size
;    };
;
; Expected vertex shaders constants
;    c0-c3   = Combined Matrix
;    c4		 = Light0 direction
;	 c5		 = Eye vector (Look direction--not direction to viewer)
;	 c6		 = Scratch constants { 0.0f, 0.5f, 1.0f, 0.2f }
;
;------------------------------------------------------------------------------

;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 r1.w, v0, c3	;save off r1.w for dot size calc
mov oPos.w, r1.w

; get light/eye half angle
mov r0, c4
sub r0, r0, c5

; normalize half-angle
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul r0, r0, r0.w

;pass the diffuse color
mov oD0, v2

; dot the half angle with normal, store in alpha
dp3 r2.x, r0, v1
mul r2.x, r2.x, r2.x
mul r2.x, r2.x, r2.x
max oD0.w, r2.x, c6.x

; generate dot size based on perspective distance
;rcp r1.x, r1.w	;do the 1/w
rsq r1.x, r1.w	;do the 1/w^2
mul oPts.x, r1.x, v3.x
    %   x 	       l6 p       l6 Hp     @ l6 (p     ` l6 p       l6p       l6Hp       l6Pp     @G6 x    ` l( p0         2@ @@ "@ "@                 vs.1.0


;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 oPos.w, v0, c3

;modulate the intensity with material color
mov oD0, v1
mov oT0, v2
mov oT1, v3   9   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6Pp      l6PHp      l6P(p      l6 !    ll6L0!     @lh%P       M l Xp     U$M lXHp     @G6 x    ` l( p0         2@ "@ "@                      
                     vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHTCOMBINED_ROW0	4
#define LIGHTCOMBINED_ROW1	5
#define LIGHTCOMBINED_ROW2	6
#define LIGHTCOMBINED_ROW3	7

#define TEX_MAT1_ROW0	8
#define TEX_MAT1_ROW1	9
#define TEX_MAT1_ROW2	10
#define TEX_MAT1_ROW3	11

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;apply the texture generation matrix
dp4 oT1.x, v0, c[LIGHTCOMBINED_ROW0]
dp4 oT1.y, v0, c[LIGHTCOMBINED_ROW1]
dp4 oT1.z, v0, c[LIGHTCOMBINED_ROW2]
dp4 r0.w, v0, c[LIGHTCOMBINED_ROW3]

;clamp w to positive

slt r1, c0, c0
max r0.w, r0.w, r1.w
mov oT1.w, r0.w

;apply the texture matrix to the uvs
mov oT0, v1

;dp4 oT2.x, v2, c[TEX_MAT1_ROW0]
;dp4 oT2.y, v2, c[TEX_MAT1_ROW1]
;dp4 oT2.z, v2, c[TEX_MAT1_ROW2]
;dp4 oT2.w, v2, c[TEX_MAT1_ROW3]

mul oT2.x, v2.x, c[TEX_MAT1_ROW0].x
mul oT2.y, v2.y, c[TEX_MAT1_ROW1].y
vs.1.0

#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHTCOMBINED_ROW0	4
#define LIGHTCOMBINED_ROW1	5
#define LIGHTCOMBINED_ROW2	6
#define LIGHTCOMBINED_ROW3	7

#define TEX_MAT1_ROW0	8
#define TEX_MAT1_ROW1	9
#define TEX_MAT1_ROW2	10
#define TEX_MAT1_ROW3	11

#define SCRATCH_CONST 13
#define FOG_SCALE 12

#define WORLD_ROW1	14

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;apply the texture generation matrix
dp4 oT1.x, v0, c[LIGHTCOMBINED_ROW0]
dp4 oT1.y, v0, c[LIGHTCOMBINED_ROW1]
dp4 oT1.z, v0, c[LIGHTCOMBINED_ROW2]
dp4 r0.w, v0, c[LIGHTCOMBINED_ROW3]

;clamp w to positive

slt r1, c0, c0
max r0.w, r0.w, r1.w
mov oT1.w, r0.w

;apply the texture matrix to the uvs
mov oT0, v1

dp4 oT2.x, v2, c[TEX_MAT1_ROW0]
dp4 oT2.y, v2, c[TEX_MAT1_ROW1]
dp4 oT2.z, v2, c[TEX_MAT1_ROW2]
dp4 oT2.w, v2, c[TEX_MAT1_ROW3]

;generate the fog texture coord
dp4 r0.x, v0, c[COMBINED_ROW2]
add r0.x, r0.x, -c[FOG_SCALE].x
mul r0.x, r0.x, c[FOG_SCALE].y

dp4 r0.y, v0, c[WORLD_ROW1]
add r0.y, r0.y, -c[FOG_SCALE].z
mul r0.y, r0.y, c[FOG_SCALE].w

max r0.xy, r0.xy, c[SCRATCH_CONST].xx
min r0.xy, r0.xy, c[SCRATCH_CONST].zz
mov oT3.xy, r0.xy
   =   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(    Ml6$L0(     Ll64T@/      Ml T`(     L l6dp/     ` m6D    @G6 x     M l6p      M l68p     ` l( p0         2@ @ "@                                                             	         xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_DIFFUSE0	5
#define LIGHT_DIR1		6
#define LIGHT_DIFFUSE1	7

#define SCRATCH_CONST	8
#define MATERIAL_DIFFUSE 9

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 r0, v1, -c[LIGHT_DIR0]
;make sure it is non negative
max r0.x, r0.x, c[SCRATCH_CONST].x
;modulate with light color
mul r0, r0.x, c[LIGHT_DIFFUSE0]

;do the second light
dp3 r1, v1, -c[LIGHT_DIR1]
;make sure it is non negative
max r1.x, r1.x, c[SCRATCH_CONST].x
;modulate with light color
mul r1, r1.x, c[LIGHT_DIFFUSE1]

;add the lights togather and modulate with diffuse
add r0, r0, r1
mul oD0, r0, c[MATERIAL_DIFFUSE]
mul oB0, r0, c[MATERIAL_DIFFUSE]
;mov oD0, c[SCRATCH_CONST].xxxx
;mov oB0, c[SCRATCH_CONST].xxxx


mov oT0, v2
mov oT1, v2
   !   x        l6 p       l6 Hp     @ l6 (p     ` l6 p     UL l6p       l6Hp     @G6 x    ` l( p0         2@ @ "@                                                             	         vs.1.0


;transform the vertex into clip space

dp4 oPos.x, v0, c0
dp4 oPos.y, v0, c1
dp4 oPos.z, v0, c2
dp4 oPos.w, v0, c3

;do a simple directional lighting
dp3 r0, v1, -c4
;make sure it is non negative
max r0.x, r0.x, c6.x
;modulate the intensity with material color
mul oD0, v1.y, c5
;mov oD0, c5
mov oT0, v2   5   x 
       l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
p       l6Hp       l6PH .     l6$0(     l6$0"    @G6 x     m
64T@:    ` l(  p0    * M lDQp          2@ @ "@ @                                                   xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_X			5
#define LIGHT_Z			6

#define SCRATCH_CONST	8

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 oD0, v1, -c[LIGHT_DIR0]

mov oT0, v2

mov r1, v3
dp3 r2.x, r1, c[LIGHT_X]
dp3 r2.z, r1, c[LIGHT_Z]
add r2.xz, r2.xz, c[SCRATCH_CONST].z
mul oT1.xz, r2.xz, c[SCRATCH_CONST].y
mov oT1.y, v3.y
mov oT1.w, c[SCRATCH_CONST].z

xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define LIGHT_DIR0		4
#define LIGHT_X			5
#define LIGHT_Z			6

#define SCRATCH_CONST	8

#define FOG_SCALE 12
#define WORLD_ROW1	14

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

;do the first light
dp3 oD0, v1, -c[LIGHT_DIR0]

mov oT0, v2

mov r1, v3
dp3 r2.x, r1, c[LIGHT_X]
dp3 r2.z, r1, c[LIGHT_Z]
add r2.xz, r2.xz, c[SCRATCH_CONST].z
mul oT1.xz, r2.xz, c[SCRATCH_CONST].y
mov oT1.y, v3.y
mov oT1.w, c[SCRATCH_CONST].z

;generate the fog texture coord
dp4 r0.x, v0, c[COMBINED_ROW2]
add r0.x, r0.x, -c[FOG_SCALE].x
mul r0.x, r0.x, c[FOG_SCALE].y

dp4 r0.y, v0, c[WORLD_ROW1]
add r0.y, r0.y, -c[FOG_SCALE].z
mul r0.y, r0.y, c[FOG_SCALE].w

max r0.xy, r0.xy, c[SCRATCH_CONST].xx
min r0.xy, r0.xy, c[SCRATCH_CONST].zz
mov oT3.xy, r0.xy   -   x        l6 p       l6 Hp     @ l6 (p     ` l6 p       l6Hp       l6 /    * m 6$0:    @G6 x    * M l4 *       l6$Pp     ` l( p0         2@ @ "@ @                          xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define SCRATCH_CONST	8

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

mov oT0, v2

mov r1, v3
add r1.xz, r1.xz, c[SCRATCH_CONST].z
mul r1.xz, r1.xz, c[SCRATCH_CONST].y
mov oT1, r1


xvs.1.0


#define COMBINED_ROW0	0
#define COMBINED_ROW1	1
#define COMBINED_ROW2	2
#define COMBINED_ROW3	3

#define SCRATCH_CONST	8
#define FOG_SCALE 12
#define WORLD_ROW1	14

;transform the vertex into clip space

dp4 oPos.x, v0, c[COMBINED_ROW0]
dp4 oPos.y, v0, c[COMBINED_ROW1]
dp4 oPos.z, v0, c[COMBINED_ROW2]
dp4 oPos.w, v0, c[COMBINED_ROW3]

mov oT0, v2

mov r1, v3
add r1.xz, r1.xz, c[SCRATCH_CONST].z
mul r1.xz, r1.xz, c[SCRATCH_CONST].y
mov oT1, r1

;generate the fog texture coord
dp4 r0.x, v0, c[COMBINED_ROW2]
add r0.x, r0.x, -c[FOG_SCALE].x
mul r0.x, r0.x, c[FOG_SCALE].y

dp4 r0.y, v0, c[WORLD_ROW1]
add r0.y, r0.y, -c[FOG_SCALE].z
mul r0.y, r0.y, c[FOG_SCALE].w

max r0.xy, r0.xy, c[SCRATCH_CONST].xx
min r0.xy, r0.xy, c[SCRATCH_CONST].zz
mov oT3.xy, r0.xy
    =   x        l6 p       l6 Hp     @ l6 (p     ` l6 p      l6
 (    ¬ l6
P(      Ml $0(     L l64@/      Ml T`(     L l6dp/     ` m6D    @G6 x     M l6/    @m l6p0    ` l( p0         2@ 2@                                                             	         
             ;------------------------------------------------------------------------------
; Vertex shader to do gouraud shading with 2 lights (xyz, normal)
;------------------------------------------------------------------------------
vs.1.0

;------------------------------------------------------------------------------
; Vertex type expected by this shader
;    struct VERTEX
;    {
;       D3DXVECTOR3 p;        // v0.xyz  = Vertex position
;       D3DXVECTOR3 n;        // v1.xyz  = Vertex normal
;    };
;
; Expected vertex shaders constants
;    c0-c3   = Combined matrix
;	 c4		 = Light1 direction
;	 c5		 = Light1 diffuse
;	 c6		 = Light2 direction
;	 c7		 = Light2 diffuse
;	 c8		 = Scratch constants
;	 c9		 = Material diffuse
;	 c10	 = Material ambient
;
;------------------------------------------------------------------------------

m4x4 oPos, v0, c0

;do the first light
dp3 r0, v1, -c4
;make sure it is non negative
max r0.x, r0.x, c8.x
;modulate with light color
mul r0, r0.x, c5

;do the second light
dp3 r1, v1, -c6
;make sure it is non negative
max r1.x, r1.x, c8.x
;modulate with light color
mul r1, r1.x, c7

;add the lights together, modulate with diffuse, and add ambient
add r0, r0, r1
mul r0, r0, c9
add oD0, r0, c10
VDRIVDIR
billboard.gvs;$   8                      
billboard.vsh;\                        	cloth.gvs;  P                      	cloth.vsh;,                        	exp1a.gvs;   x                      	exp1a.vsh;
                        	exp1b.gvs;/                        	exp1b.vsh;K  G                      feature.gvs;                        feature.vsh;>  `                      flaresp.gvs;$                         flaresp.vsh;R%  t                      fog.vsh;&  '                      fog.xvu;'  d                       gui.gvs;Q(  |                      gui.vsh;)                        guinorm.gvs;j.  d                      guinorm.vsh;1  	                      	guyai.gvs;;  P                      	guyai.vsh;<                        	guyns.gvs;w@                        	guyns.vsh;#B                        	guysh.gvs;F                        	guysh.vsh;I                        hat.gvs;AP  P                      hat.vsh;Q                        impulse.gvs;/U                         impulse.vsh;U                         	lense.gvs;V                        	lense.vsh;UX  *                      	light.gvs;\                        	light.vsh;]                        	lines.gvs;:c                         	lines.vsh;c                         lodgebmp.gvs;td                        lodgebmp.vsh;4f  :                      lodged3d.gvs;nl  P                      lodged3d.vsh;m                        lodgeref.gvs;Zq                        lodgeref.vsh;r  *                      pana.gvs;$w                         pana.vsh;w                        perftest.gvs;x                        perftest.vsh;y                        pointsp.gvs; |                         pointsp.vsh;|  X                      
pointspns.gvs;~                         
pointspns.vsh;~                         ppl.gvs;                        ppl.vsh;u                        shadbuf.gvs;                         shadbuf.vsh;  1                      
shadow.gvs;                         
shadow.vsh;  p                      skin.gvs;                        skin.vsh;  	                      
skinai.gvs;Z  d                      
skinai.vsh;                        
skinns.gvs;m  $                      
skinns.vsh;                        
skinpl.gvs;Q                        
skinpl.vsh;U                        skinpls.gvs;0  H                      skinpls.vsh;x                        skinsbuf.gvs;$  D                      skinsbuf.vsh;h  -                      sparkle.gvs;  P                      sparkle.vsh;                        	spray.gvs;                         	spray.vsh;                         terrain.gvs;{  <                      terrain.vsh;                        terrainfog.vsh;  `                      test.gvs;5  p                      test.vsh;                        	trail.gvs;                         	trail.vsh;  I                      tree.gvs;  <                      tree.vsh;:                        treefog.vsh;                        treevol.gvs;                        treevol.vsh;                       treevolfog.vsh;i )                      	xyz2l.gvs; |                      	xyz2l.vsh;	                       U 